% Napisati MatLAB program koji eksplicitno zadatu funkciju f tabelira na 
% intervalu ciji je levi kraj tacka a sa korakom h = 1/n, n = 1,2,...,m,
% koristeci tacno k cvorova (vrednosti m,k iz N zadaje korisnik). Za svaku
% vrednost n, program treba da formira odgovarajuci I Njutnov
% interpolacioni polinom koristeci svih k cvorova. Zatim, program treba da
% omoguci izracunavanje priblizne vrednosti funkcije f u proizvoljnoj tacki
% x koriscenjem dobijenih polinoma uz poredjenje dobijenih vrednosti sa
% tacnom vrednoscu f(x). Graficki prikazati.

function tabeliraj
str = input('Unesite funkciju: f(x) = ','s');
fodx=inline(str);
a = input('Unesite pocetnu vrednost (a): ');
m = input('Unesite m(korak h = 1/n, n = 1,...,m): ');       % obrada gresaka            %
if ((m - floor(m)) ~= 0) | m < 0                            % unos trazenih vrednosti   %
    error('m mora biti prirodan broj!')
end
k = input('Unesite broj cvorova k: ');
if ((k - floor(k)) ~= 0) | k < 0
    error('k mora biti prirodan broj')
end
w = a+2/m;
fprintf('NAPOMENA: Ova tacka bi trebalo da bude izmedju %g i %g\n', a, w);
xnad = input('Unesite tacku za priblizno izracunavanje vrednosti funkcije: ');

vre = fodx(xnad);                                    % tacna vrednost funkcije u tacki %

% cuvanje uentih vrednosti
a1 = a;
m1 = m;
k1 = k;

% matrice koja simuliraju tabele

T = zeros(k,2);
K = zeros(k-1, k-1);

% tabeliranje funkcije za svako n
for n = 1:m
    h = 1/n
    % tabeliranje funkcije za svaki cvor - k
    for count = 1:k
        T(count,1) = a;   % prva kolona su cvorovi
        T(count,2) = fodx(T(count,1));  % druga kolona su vrednosti u tim cvorovima
        a=a+h;  % cvorovi rastu linearno za h...
    end
    a = a1;
    T
% formiranje I Njutnovog polinoma za svako ovo n

% odredjivanje x0
if xnad > T(1,1) & xnad < T(2,1)
    x0=T(1,1);
    v=1;
elseif xnad > T(2,1) & xnad < T(3,1)
    x0=T(2,1);
    v=2;
else
    error('I Njutnov polinom moze da radi samo blizu pocetka tablice!')
end
q = (xnad - x0) / h;
% konacne razlike
gh = k-1;
for s = 1:gh
    K(s,1) = T(s+1,2) - T(s,2);
end

for i=1:(gh-1)
    for j=2:(gh)
        K(i,j)=K(i+1,j-1)-K(i,j-1);
    end
    gh=gh-1;
end
K;

Newton(T,K,q,k,v,vre)
    
end % for spoljni

% crtanje grafika funkcije f(x) = ...
 fplot(fodx,[a1,a1+k1])%,'.-r')
 grid on
 axis tight
 hold on